
@extends('templates.prefeitura3.transparencia.layout')

@section('header')

    <title>Despesas - Portal da Transparência</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link href="https://fonts.googleapis.com/css?family=Rubik:300,400,700|Oswald:400,700" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Open+Sans|Roboto&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Poppins&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

    <link rel="stylesheet" href="{{url('')}}/transpa/fonts/icomoon/style.css">

    <link rel="stylesheet" href="{{url('')}}/transpa/css/bootstrap.min.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/jquery.fancybox.min.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/owl.carousel.min.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/owl.theme.default.min.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/fonts/flaticon/font/flaticon.css">

    <link rel="stylesheet" href="{{url('')}}/transpa/css/aos.css">

    <!-- MAIN CSS -->
    <link rel="stylesheet" href="{{url('')}}/transpa/css/style.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/style2.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/style5.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/style7.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/footer.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/scss/barraacessibilidade.scss">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/barraacessibilidade.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/accordion.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/formulariotabela.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/bootstrap-datepicker.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/font-awesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/font-awesome/css/all.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/bootstrap-datepicker2.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/font-awesome.min.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/modal.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/plugins/aos-master/aos.css"/>
    <link rel="stylesheet" href="{{url('')}}/transpa/css/animations.css">

    <style>

        .page-item.active .page-link {

            background-color: #337ab7!important;
            border-color: #337ab7;
        }
    </style>


@endsection


@section('menu')

    <!-- <li><a href="#home-section" class="nav-link">Página Inicial</a></li> -->
    <li><a href="{{routeTenant('site.transparencia.index')}}#about-section" class="nav-link">Sobre</a></li>
    <li><a href="{{routeTenant('site.transparencia.index')}}#nova-legislacao" class="nav-link">Legislação</a></li>
    <li><a href="{{routeTenant('site.transparencia.index')}}#faq" class="nav-link">Perguntas Frequentes</a></li>

@endsection



@section('content')



    <div class="row barra" >

        <div class="container" >

            <div class="col-md-8" style="padding-top: 10px;">

                <i style="font-size: 23px;" class="flaticon-crane"></i>

                <?php  use App\Transparencia;?>
                <?php if(!isset($formdata)){?>
                <span style="font-size: 16px;">&nbsp; DESPESAS de: <strong> <?php  $data = Transparencia::orderBy('data', 'asc')->first()->data->format('d/m/Y'); ?> {{$data}}</strong> a <strong> <?php  $data = Transparencia::orderBy('data', 'desc')->first()->data->format('d/m/Y'); ?> {{$data}}</strong></span>
                <?php }else{?>
                <span style="font-size: 16px;">&nbsp; DESPESAS de: <strong> @if($dataform['dataini']) {{$dataform['dataini']}} @endif</strong>  a <strong> @if($dataform['datafim']) {{$dataform['datafim']}} @endif  </strong></span>

                <?php }?>
            </div>

            <div class="col-md-4" style="padding-top: 10px;" >
                <button class="btn2"><i class="fa fa-print"></i> Imprimir</button>
                <button class="btn2"><i class="fa fa-download"></i> Download</button>
            </div>


        </div>
    </div>

    <!-- FECHA BARRA -->







    <!-- FORMULÁRIO -->
    <div class="container">
        <div class="row" style="background-color: #eff0f2; padding: 20px;">
            <div  class=" col-md-12 ">

                <div class="row">
                    <div class="col-md-12 ">
                        <form method="post" action="{{routeTenant('site.transparencia.despesas.busca')}}" class="form2">
                            <div class="row">
                                <input type="hidden" name="_token" value="{{csrf_token()}}">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="">Número do Pagamento:</label>
                                        <div class="form-field">

                                            <input type="text" name="numero" id="numerop" value="@if(isset($dataform))@if(isset($dataform['numero'])) {{$dataform['numero']}}@endif @endif" class="form-control">


                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="">Favorecido:</label>
                                        <div class="form-field">

                                            <input type="text" name="favorecido" value="@if(isset($dataform)) @if(isset($dataform['favorecido'])){{$dataform['favorecido']}} @endif @endif" id="nfavorecido" class="form-control">


                                        </div>
                                    </div>
                                </div>

                                <!--<div class="col-md-3">
                                  <div class="form-group">
                                    <label for="children">Favorecido:</label>
                                    <div class="form-field">
                                      <i class="icon icon-arrow-down3"></i>
                                      <select name="people" id="people" class="form-control">
                                        <option value="#">Item 1</option>
                                        <option value="#">Item 2</option>
                                        <option value="#">Item 3</option>
                                        <option value="#">Item 4</option>
                                        <option value="#">Item 5</option>
                                      </select>
                                    </div>
                                  </div>
                                </div>-->

                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="date">Período: </label>
                                        <div class="form-field">
                                            <i class="icon icon-calendar2"></i>
                                            <input type="text" autocomplete="off" id="date" value="@if(isset($dataform)) @if(isset($dataform['dataini'])) {{$dataform['dataini']}} @endif @endif" name="dataini" class="form-control datepicker" placeholder="De">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="date" style="color: lightgrey">&nbsp;</label>
                                        <div class="form-field">
                                            <i class="icon icon-calendar2"></i>
                                            <input type="text" autocomplete="off" id="date" name="datafim" value="@if(isset($dataform)) @if(isset($dataform['datafim'])){{$dataform['datafim']}} @endif @endif" class="form-control datepicker" placeholder="Até">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-2">
                                    <input type="submit" name="submit" id="submit" value="Buscar" class="btn3">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- FECHA FORMULÁRIO -->







    <!-- TABELA -->

    <div class="container" id="containertabela">
        <!--<h2></h2>-->
        <div class="atualizado">
            <p style="font-size: 14px;">Atualizado em: <span class="datadeatualizacao"><b>
                        <?php  $data = Transparencia::orderBy('data', 'asc')->first()->created_at->format('d/m/Y H:i:s'); ?>
                        {{$data}}</b></span><span class="horaatualizacao"> </span> &nbsp;| &nbsp;Último pagamento: <span class="atualizacaorecente"><b>
{{--                        {{date('d/m/y',  strtotime($dtPagamento)) }} --}}
                    </b></span></p>
        </div>

        <table class="table table-hover table-condensed" id="tabela1">
            <thead class="titulostabela">
            <tr>
                <th>Nº do Pagamento</th>
                <th>Data</th>
                <th>Favorecido</th>
                <th>Valor</th>
            </tr>
            </thead>
            <tbody>

            @foreach($dadoscolection as $category)


                <tr class="linhas">
                    <td><a href="{{routeTenant('site.transparencia.despesas.detalhes',[$category['nroOP']])}}"
                           class="popup">{{substr($category['nroOP'], -4)}}/{{date('Y',  strtotime($category['dtPagamento'])) }} </a></td>
                    <td>{{date('d/m/Y',  strtotime($category['dtPagamento'])) }} </td>
                    <td><a href="{{routeTenant('site.transparencia.despesas.detalhes',[$category['nroOP']])}}"
                           class="popup">{{$category['nomeRazaoSocial']}}  </a></td>
                    <td>R$ @if(isset($category['vlOP'])){{number_format(preg_replace('/(?<=\d),+(?=\d)/', '.', floatval($category['vlOP'])),2,",",".")}}@endif</td>
                </tr>

            @endforeach


            </tbody>
        </table>


        <div class="total">
            <p style="font-size: 16px;">Valor total: <span class="valortotal"><b>R${{number_format($total,2,",",".")}}</b></span></p>
        </div>

    </div>

    <div class="container">

        <div class="center">

            @if(isset($dataform))
                {!! $dadoscolection->appends($dataform)->links() !!}
            @else
                {!! $dadoscolection->links() !!}
            @endif

        </div>

    </div>



    <!-- MODAL DESPESAS -->




    </div>









    <!-- FECHA MODAL DESPESAS -->



@endsection

@section('footer')



    <script src="{{url('')}}/transpa/js/jquery-3.3.1.min.js"></script>
    <script src="{{url('')}}/transpa/js/popper.min.js"></script>
    <script src="{{url('')}}/transpa/js/bootstrap.min.js"></script>
    <script src="{{url('')}}/transpa/js/owl.carousel.min.js"></script>
    <script src="{{url('')}}/transpa/js/jquery.sticky.js"></script>
    <script src="{{url('')}}/transpa/js/jquery.waypoints.min.js"></script>
    <script src="{{url('')}}/transpa/js/jquery.animateNumber.min.js"></script>
    <script src="{{url('')}}/transpa/js/jquery.fancybox.min.js"></script>
    <script src="{{url('')}}/transpa/js/jquery.easing.1.3.js"></script>
    <script src="{{url('')}}/transpa/js/aos.js"></script>
    <script src="{{url('')}}/transpa/js/bootstrap-datepicker.js"></script>
    <script src="{{url('')}}/transpa/js/bootstrap-datepicker.pt-BR.js"></script>

    <script src="{{url('')}}/transpa/js/main.js"></script>

    <script src="{{url('')}}/transpa/js/accordion.js"></script>
    <script src="{{url('')}}/transpa/js/jquery.flexslider-min.js"></script>

    <script src="{{url('')}}/transpa/js/aos2.js"></script>
    <script src="{{url('')}}/transpa/js/aos3.js"></script>
    <!--<script src="js/main2.js"></script>-->
    <script src="{{url('')}}/transpa/js/barraacessibilidade.js"></script>
    <script src="{{url('')}}/transpa/js/nav.js"></script>
    <script src="{{url('')}}/transpa/js/botao.js"></script>


    <script src="{{url('')}}/transpa/js/jquery.waypoints.min2.js"></script>
    <script src="{{url('')}}/transpa/js/jquery.flexslider-min2.js"></script>
    <script src="{{url('')}}/transpa/js/owl.carousel.min2.js"></script>
    <script src="{{url('')}}/transpa/js/main3.js"></script>



    <script type="text/javascript" src="{{url('')}}/transpa/plugins/numScroll/numscroller-1.0.js"></script>


    <script src="{{url('')}}/transpa/plugins/aos-master/aos.js"></script>

    <script type="text/javascript" src="{{url('')}}/transpa/plugins/niceScroll/niceScroll.min.js"></script>

    <script>
        $(document).ready(function () {
            $('.datepicker').datepicker({
                format: 'dd/mm/yyyy',
                language: 'pt-BR'
            });
        });
    </script>


    <script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.fancybox.js"></script>
    <link href="{{url('')}}/templates/prefeitura1/licitacao/css/jquery.fancybox.css" rel="stylesheet">
    <script type="text/javascript">
        $(function(){
            $('.fancybox').fancybox();
            $(".popup").fancybox({'width':'80%','height':'250px','autoScale':true,
                'fitToView' : false,
                'autoSize' : false,
                'transitionIn':'none',
                'transitionOut':'none',
                'type':'iframe'});

            $(".open_modal_large").fancybox({'width':'98%','height':'90%','autoScale':false,
                'transitionIn':'none','transitionOut':'none','type':'iframe'});
            $(".open_modal_small").fancybox({'width':'50%','height':'90%','autoScale':false,
                'transitionIn':'none','transitionOut':'none','type':'iframe'});

            $('#news_icon').hover(function(){
                $(this).stop(true,true).animate({'right':'0px'}, 'fast');
            }, function(){
                $(this).stop(true,true).animate({'right':'-130px'}, 'fast');
            });


            $('#btn_mobile').on('click', function(){
                $('#menubar, .asidebar, #top-menubar').stop(true,true).slideToggle();
            });
        });


    </script>

@endsection
