
@extends('templates.prefeitura3.transparencia.layout')






@section('header')


    <title>Portal da Transparência</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link href="https://fonts.googleapis.com/css?family=Rubik:300,400,700|Oswald:400,700" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Open+Sans|Roboto&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Poppins&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="{{url('')}}/transpa/fonts/icomoon/style.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/bootstrap.min.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/jquery.fancybox.min.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/owl.carousel.min.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/owl.theme.default.min.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/fonts/flaticon/font/flaticon.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/aos.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/font-awesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/font-awesome/css/all.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/font-awesome.min.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/plugins/aos-master/aos.css"/>
    <link rel="stylesheet" href="{{url('')}}/transpa/css/animations.css">

    <link rel="stylesheet" href="{{url('')}}/transpa/css/style.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/footer.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/scss/barraacessibilidade.scss">




@endsection

@section('menu')

    <!-- <li><a href="#home-section" class="nav-link">Página Inicial</a></li> -->
    <li><a href="#about-section" class="nav-link">Sobre</a></li>
    <li><a href="#nova-legislacao" class="nav-link">Legislação</a></li>
    <li><a href="#faq" class="nav-link">Perguntas Frequentes</a></li>

@endsection



@section('content')

{{--@php dd($portal) @endphp--}}

    <!-- TRANSPARÊNCIA -->

    <div class="transparencia-mobile">

        <!-- <div class="site-section bg-light" id="services-section"> -->

        <div class="site-section" id="services-section">

            <div class="container">

                <div class="row mb-5 justify-content-center">

                    <div class="col-md-7 text-center">

                        <div class="block-heading-1">

                            <!--<h2>Transparência</h2>-->
                            <!--<p>Texto</p>-->

                        </div>

                    </div>

                </div>

                <div class="owl-carousel owl-all">

@if($portal->trasparencia_receita == 1)
                    <a href="{{routeTenant('site.transparencia.receitas')}}">
                        <div class="block__35630_mobile">
                            <div class="icon mb-0">
                                <span class="flaticon-save-money" style="margin-left: 10px;"></span>
                            </div>
                            <h3 class="mb-3">Receitas</h3>
                            <p>Acompanhe as receitas recebidas pelo <br> município</p>
                        </div>
                    </a>
@endif
    @if($portal->trasparencia_despesa == 1)
                    <a href="{{routeTenant('site.transparencia.despesas')}}">
                        <div class="block__35630_mobile">
                            <div class="icon mb-0">
                                <span class="flaticon-crane"></span>
                            </div>
                            <h3 class="mb-3">Despesas</h3>
                            <p>Acompanhe todas as informações referente às despesas</p>
                        </div>
                    </a>


    @endif
    @if($portal->trasparencia_licitacao == 1)



                    <a href="{{routeTenant('site.transparencia.licitacoes')}}">
                        <div class="block__35630_mobile">
                            <div class="icon mb-0">
                                <span class="flaticon-auction"></span>
                            </div>
                            <h3 class="mb-3">Licitações</h3>
                            <p>Confira todas as licitações <br> realizadas</p>
                        </div>
                    </a>

    @endif
    @if($portal->trasparencia_contratos == 1)


                    <a href="{{routeTenant('site.transparencia.contratos')}}">
                        <div class="block__35630_mobile">
                            <div class="icon mb-0">
                                <span class="flaticon-file" style="margin-left: 20px;"></span>
                            </div>
                            <h3 class="mb-3">Contratos</h3>
                            <p>Confira todos os contratos celebrados <br> pela prefeitura</p>
                        </div>
                    </a>

    @endif
    @if($portal->trasparencia_diarias == 1)


                    <a href="{{routeTenant('site.transparencia.diarias')}}">
                        <div class="block__35630_mobile">
                            <div class="icon mb-0">
                                <span class="flaticon-travel"></span>
                            </div>
                            <h3 class="mb-3">Diárias de Viagens</h3>
                            <p>Confira a relação dos gastos com diárias e passagens dos servidores</p>
                        </div>
                    </a>

    @endif
    @if($portal->trasparencia_servidores == 1)



                    <a href="{{routeTenant('site.transparencia.servidores')}}">
                        <div class="block__35630_mobile">
                            <div class="icon mb-0">
                                <span class="flaticon-groups"></span>
                            </div>
                            <h3 class="mb-3">Servidores Públicos</h3>
                            <p>Confira a relação dos salários de todos os servidores</p>
                        </div>
                    </a>


    @endif
    @if($portal->trasparencia_legislacao == 1)


                    <a href="#nova-legislacao">
                        <div class="block__35630_mobile">
                            <div class="icon mb-0">
                                <span class="flaticon-balance"></span>
                            </div>
                            <h3 class="mb-3">Legislação</h3>
                            <p>Confira a relação das Leis, Decretos e demais legislações municipais</p>
                        </div>
                    </a>

    @endif
    @if($portal->trasparencia_convenios == 1)
                    <a href="#">
                        <div class="block__35630_mobile">
                            <div class="icon mb-0">
                                <span class="flaticon-hand-shake"></span>
                            </div>
                            <h3 class="mb-3">Convênios</h3>
                            <p>Confira a quantidade de recursos repassados por meio de convênios</p>
                        </div>
                    </a>
    @endif
    @if($portal->trasparencia_gestao == 1)
                    <a href="#">
                        <div class="block__35630_mobile">
                            <div class="icon mb-0">
                                <span class="flaticon-collaboration"></span>
                            </div>
                            <h3 class="mb-3">Gestão</h3>
                            <p>Veja as unidades que formam a nossa estrutura organizacional</p>
                        </div>
                    </a>
    @endif
                </div>

            </div>

        </div>

    </div>

    <!-- FECHA TRANSPARÊNCIA -->



    <!-- SOBRE -->

    <section class="site-section-about" id="about-section">

        <div class="container">

            <div class="novo-sobre">

                <div class="row hover-1-wrap mb-5 mb-lg-0">

                    <div class="col-12">

                        <div class="row">

                            <div class="mb-4 mb-lg-0 col-md-6 order-lg-2" data-aos="fade-left" data-aos-duration="1000">

                                <img src="{{url('')}}/transpa/images/sobre.jpg" alt="Image" class="img-fluid">

                            </div>

                            <div class="col-md-6 mr-auto text-lg-right align-self-center order-lg-1" data-aos="fade-right" data-aos-duration="1000">

                                <h2 class="text-black">Portal da Transparência</h2>

                                <h3 class="text-primary">Gestão à vista de todos</h3>

                                <br>

                                <p class="mb-4" style= "text-align=left">As Tecnologias de Informação e Comunicação (TICs) são instrumentos cada vez mais importantes no desenvolvimento de ferramentas que melhorem a prestação de serviços e informações para os cidadãos.</p>
                                <p class="mb-4">A adoção dessas tecnologias permite o aumento da eficácia, da eficiência e da transparência governamental. A adoção de meios eletrônicos para a prestação dos serviços governamentais exige que os sítios e portais desenvolvidos e mantidos pela administração pública sejam fáceis de usar, relevantes e efetivos. Somente por meio da eficiência é possível aumentar a satisfação dos usuários de serviços eletrônicos e conquistar, gradativamente, uma parcela cada vez maior da população.</p>
                                <p class="mb-4">É, portanto, responsabilidade da administração pública oferecer ao cidadão a melhor experiência possível de acesso ao governo eletrônico, respeitando inclusive, as particularidades da população atingida.</p>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </section>

    <!-- FECHA SOBRE -->


    <!-- SOBRE MOBILE -->

    <section class="site-section-about-mobile" id="about-section-mobile">

        <div class="container">

            <div class="novo-sobre-mobile">

                <div class="row hover-1-wrap mb-5 mb-lg-0">

                    <div class="col-12">

                        <div class="row">

                            <div class="col-md-6 mr-auto text-lg-right align-self-center order-lg-1" data-aos="fade-right" data-aos-duration="1000">

                                <h2 class="text-black">Portal da Transparência</h2>

                                <h3 class="text-primary">Gestão à vista de todos</h3>

                                <div class="mb-4 mb-lg-0 col-md-6 order-lg-2" data-aos="fade-left" data-aos-duration="1000">

                                    <img src="{{url('')}}/transpa/images/sobre-2.jpg" alt="Image" class="img-fluid">

                                </div>

                                <p class="mb-4" style= "text-align=left">As Tecnologias de Informação e Comunicação (TICs) são instrumentos cada vez mais importantes no desenvolvimento de ferramentas que melhorem a prestação de serviços e informações para os cidadãos.</p>
                                <p class="mb-4">A adoção dessas tecnologias permite o aumento da eficácia, da eficiência e da transparência governamental. A adoção de meios eletrônicos para a prestação dos serviços governamentais exige que os sítios e portais desenvolvidos e mantidos pela administração pública sejam fáceis de usar, relevantes e efetivos. Somente por meio da eficiência é possível aumentar a satisfação dos usuários de serviços eletrônicos e conquistar, gradativamente, uma parcela cada vez maior da população.</p>
                                <p class="mb-4">É, portanto, responsabilidade da administração pública oferecer ao cidadão a melhor experiência possível de acesso ao governo eletrônico, respeitando inclusive, as particularidades da população atingida.</p>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </section>

    <!-- FECHA SOBRE MOBILE -->



    <!-- LEGISLAÇÃO -->

    <section class="site-section" id="legislacao-section">

        <div class="container">

            <div class="nova-legislacao" id="nova-legislacao">

                <div class="row hover-1-wrap mb-5 mb-lg-0">

                    <div class="col-12">

                        <div class="row">

                            <div class="mb-4 mb-lg-0 col-md-6"  data-aos="fade-right" data-aos-duration="1000">

                                <img src="{{url('')}}/transpa/images/legislacao.jpg" alt="Image" class="img-fluid">

                            </div>

                            <div class="col-md-6 ml-auto align-self-center"  data-aos="fade-left" data-aos-duration="1000">

                                <h2 class="text-black">Legislação</h2>

                                <h3 class="text-primary">Leis e decretos que garantem o acesso à informação</h3>

                                <br>

                                <div class="lista">

                                    <p><a href="http://www.planalto.gov.br/ccivil_03/_ato2011-2014/2011/lei/l12527.htm" target="_blank" class="white">&#10004;&nbsp;&nbsp;Lei Federal Nº 12.527/2012 - Acesso à informação</a></p>
                                    <p><a href="http://www.planalto.gov.br/ccivil_03/leis/LCP/Lcp101.htm" target="_blank" class="white">&#10004;&nbsp;&nbsp;Lei Complementar nº 101, de 4 de maio de 2000</a></p>
                                    <p><a href="http://www.planalto.gov.br/ccivil_03/leis/lcp/lcp131.htm" target="_blank" class="white">&#10004;&nbsp;&nbsp;Lei Complementar nº 131, de 27 de maio de 2009</a></p>
                                    <p><a href="http://www.planalto.gov.br/ccivil_03/_ato2007-2010/2010/decreto/d7185.htm" target="_blank" class="white">&#10004;&nbsp;&nbsp;Decreto nº 7.185, de 27 de maio de 2010</a></p>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </section>

    <!-- FECHA LEGISLAÇÃO -->



    <!-- LEGISLAÇÃO MOBILE -->

    <section class="site-section-mobile" id="legislacao-section-mobile">

        <div class="container">

            <div class="nova-legislacao-mobile" id="nova-legislacao-mobile">

                <div class="row hover-1-wrap mb-5 mb-lg-0">

                    <div class="col-12">

                        <div class="row">

                            <div class="col-md-6 ml-auto align-self-center"  data-aos="fade-left" data-aos-duration="1000">

                                <h2 class="text-black">Legislação</h2>

                                <h3 class="text-primary">Leis e decretos que garantem o acesso à informação</h3>

                                <div class="mb-4 mb-lg-0 col-md-6"  data-aos="fade-right" data-aos-duration="1000">

                                    <img src="{{url('')}}/transpa/images/legislacao-2.jpg" alt="Image" class="img-fluid">

                                </div>

                                <div class="lista">

                                    <p><a href="http://www.planalto.gov.br/ccivil_03/_ato2011-2014/2011/lei/l12527.htm" target="_blank" class="white">&#10004;&nbsp;&nbsp;Lei Federal Nº 12.527/2012 - Acesso à informação</a></p>
                                    <p><a href="http://www.planalto.gov.br/ccivil_03/leis/LCP/Lcp101.htm" target="_blank" class="white">&#10004;&nbsp;&nbsp;Lei Complementar nº 101, de 4 de maio de 2000</a></p>
                                    <p><a href="http://www.planalto.gov.br/ccivil_03/leis/lcp/lcp131.htm" target="_blank" class="white">&#10004;&nbsp;&nbsp;Lei Complementar nº 131, de 27 de maio de 2009</a></p>
                                    <p><a href="http://www.planalto.gov.br/ccivil_03/_ato2007-2010/2010/decreto/d7185.htm" target="_blank" class="white">&#10004;&nbsp;&nbsp;Decreto nº 7.185, de 27 de maio de 2010</a></p>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </section>

    <!-- FECHA LEGISLAÇÃO MOBILE -->



    <!-- FAQ -->

    <div class="faq_area" id="faq">

        <div class="container">

            <div class="row">

                <div class="col-xl-12">

                    <div class="accordion_heading">

                        <h3 style="font-size: 32px; font-weight: 900; color: #f7f7f7;">Perguntas Frequentes</h3>

                    </div>

                </div>

                <div class="col-xl-6">

                    <!-- <h2>Subtítulo</h2> -->

                    <div class="botao">

                        <div class="accordion" id="b1" data-aos="fade-up" data-aos-duration="1000"><span class="icon-question_answer text-primary mr-2"></span> Quem deve cumprir a lei? </div>

                        <div class="panel">

                            <div class="textodopainel">

                                <p>Órgãos públicos dos três poderes (Executivo, Legislativo e Judiciário) dos três níveis de governo (federal, estadual, distrital e municipal). Incluem-se os Tribunais e Contas e os Ministérios Públicos.</p>
                                <p>Autarquias, fundações públicas, empresas públicas, sociedades de economia mista e “demais entidades controladas direta ou indiretamente pela União, Estados, Distrito Federal e Municípios” também estão sujeitos à lei.</p>
                                <p>Entidades privadas sem fins lucrativos que recebam recursos públicos diretamente ou por meio de subvenções sociais, contrato de gestão, termo de parceria, convênios, acordo, ajustes e outros instrumentos devem divulgar informações relativas ao vínculo com o poder público.</p>
                                <p>• Referência na lei: Artigo 1º, parágrafo único.</p>
                                <p>Municípios com menos de 10 mil habitantes não precisam publicar na internet o conjunto mínimo de informações exigido. Entretanto, precisam cumprir a Lei da Transparência (Lei Complementar nº 131/2009).</p>
                                <p>• Referência na lei: Artigo 8º, § 4º.</p>

                            </div>

                        </div>

                    </div>


                    <div class="accordion" data-aos="fade-up" data-aos-duration="1000"><span class="icon-question_answer text-primary mr-2"></span> Transparência ativa</div>

                    <div class="panel">

                        <div class="textodopainel">

                            <p>As informações de interesse público deverão ser divulgadas “independentemente de solicitações”.</p>
                            <p>• Referência na lei: Artigo 3º, II; Artigo 8º.</p>

                        </div>

                    </div>


                    <div class="accordion" data-aos="fade-up" data-aos-duration="1000"><span class="icon-question_answer text-primary mr-2"></span>  Mínimo de informações que devem ser fornecidas</div>

                    <div class="panel">

                        <div class="textodopainel">

                            <ul style="list-style-type: disc;">

                                <li>Conteúdo institucional.</li>
                                <li>Competências, estrutura organizacional, endereços e telefones das unidades, horário de atendimento ao público e respostas às perguntas mais frequentes da sociedade.</li>
                                <li>Conteúdo financeiro e orçamentário.</li>
                                <li>Registros de repasses ou transferências de recursos financeiros, bem como de despesas.</li>
                                <li>Informações de licitações (editais, resultados e contratos celebrados).</li>
                                <li>Dados gerais sobre programas, ações, projetos e obras de órgãos e entidades.</li>
                            </ul>

                            <p>• Referência na lei: Artigo 8º, § 1º.</p>

                        </div>

                    </div>


                    <div class="accordion" id="b1" data-aos="fade-up" data-aos-duration="1000"><span class="icon-question_answer text-primary mr-2"></span> Requisitos para os sites de órgãos públicos </div>

                    <div class="panel">

                        <div class="textodopainel">

                            <p>O site deve ter uma ferramenta de pesquisa e indicar meios de contato por via eletrônica ou telefônica com o órgão que mantém o site.</p>
                            <p>Deve ser possível realizar o download das informações em formato eletrônico (planilhas e texto), e o site deve ser aberto à ação de mecanismos automáticos de recolhimento de informações (ser “machine-readable”). Deve também atender às normas de acessibilidade na web.</p>
                            <p>A autenticidade e a integridade das informações do site devem ser garantidas pelo órgão.</p>
                            <p>• Referência na lei: Artigo 8º, § 3º.</p>

                        </div>

                    </div>


                    <div class="accordion" id="b1" data-aos="fade-up" data-aos-duration="1000"><span class="icon-question_answer text-primary mr-2"></span> Estrutura e pessoal necessários para implantação </div>

                    <div class="panel">

                        <div class="textodopainel">

                            <p>Os órgãos públicos deverão criar um serviço físico de informações ao cidadão. Ele será responsável por orientar as pessoas sobre o acesso a informações, receber requerimentos e informar sobre o andamento deles. O serviço também deverá realizar audiências públicas e divulgação do acesso a informações.</p>
                            <p>• Referência na lei: Artigo 9º.</p>
                            <p>Em até 60 dias após a lei entrar em vigor, o dirigente máximo de cada um dos entes da administração pública federal direta ou indireta deverá designar uma autoridade diretamente subordinada a ele para garantir e monitorar o cumprimento da lei de acesso. Essa autoridade deverá produzir relatórios periódicos sobre a observância à lei.</p>
                            <p>• Referência na lei: Artigo 40.</p>

                        </div>

                    </div>


                    <div class="accordion" id="b1" data-aos="fade-up" data-aos-duration="1000"><span class="icon-question_answer text-primary mr-2"></span> Quem pode fazer pedidos de informação? </div>

                    <div class="panel">

                        <div class="textodopainel">

                            <p>Qualquer cidadão.</p>
                            <p>• Referência na lei: Artigo 10.</p>

                        </div>

                    </div>


                    <div class="accordion" id="b1" data-aos="fade-up" data-aos-duration="1000"><span class="icon-question_answer text-primary mr-2"></span> O que o pedido de informação deve conter? </div>

                    <div class="panel">

                        <div class="textodopainel">

                            <p>Identificação básica do requerente e especificação da informação solicitada. Não é preciso apresentar o(s) motivo(s) para o pedido. Não se pode exigir, na identificação, informações que constranjam o requerente. </p>
                            <p>• Referência na lei: Artigo 10, § 1º e 3º.</p>

                        </div>

                    </div>


                    <div class="accordion" id="b1" data-aos="fade-up" data-aos-duration="1000"><span class="icon-question_answer text-primary mr-2"></span> Como o pedido de informação pode ser feito? </div>

                    <div class="panel">

                        <div class="textodopainel">

                            <p>Por “qualquer meio legítimo”, ou seja: e-mail, fax, carta, telefonema.</p>
                            <p>• Referência na lei: Artigo 10.</p>

                        </div>

                    </div>


                    <div class="accordion" id="b1" data-aos="fade-up" data-aos-duration="1000"><span class="icon-question_answer text-primary mr-2"></span> Prazo para a concessão da informação solicitada </div>

                    <div class="panel">

                        <div class="textodopainel">

                            <p>Caso disponível, a informação deverá ser apresentada imediatamente. Se não for possível, o órgão deverá dar uma resposta em no máximo 20 dias. Esse prazo pode ser prorrogado por mais dez dias, desde que a entidade apresente motivos para o adiamento.</p>
                            <p>• Referência na lei: Artigo 11, § 1º e 2º.</p>

                        </div>

                    </div>

                </div>


                <div class="col-xl-6">


                    <div class="accordion" id="b1" data-aos="fade-up" data-aos-duration="1000"><span class="icon-question_answer text-primary mr-2"></span> Negativa de acesso </div>

                    <div class="panel">

                        <div class="textodopainel">

                            <p>O órgão público pode negar acesso total ou parcial a uma informação solicitada. Nesse caso, deverá justificar por escrito a negativa e informar ao requerente que há possibilidade de recurso. Deverão ser indicados os prazos e condições para tal recurso, além da autoridade responsável por julgá-lo.</p>
                            <p>• Referência na lei: Artigo 11, § 1º, II.</p>
                            <p>O requerente tem o direito de obter a íntegra da decisão de negativa de acesso (original ou cópia).</p>
                            <p>• Referência na lei: Artigo 14.</p>

                        </div>

                    </div>


                    <div class="accordion" id="b1" data-aos="fade-up" data-aos-duration="1000"><span class="icon-question_answer text-primary mr-2"></span> Formatos de documentos a que a lei se aplica </div>

                    <div class="panel">

                        <div class="textodopainel">

                            <p>A lei é aplicável a documentos em formato eletrônico ou físico.</p>
                            <p>• Referência na lei: Artigo 11, § 5º, 6º.</p>

                        </div>

                    </div>


                    <div class="accordion" id="b1" data-aos="fade-up" data-aos-duration="1000"><span class="icon-question_answer text-primary mr-2"></span> Cobrança </div>

                    <div class="panel">

                        <div class="textodopainel">

                            <p>Só poderá ser cobrado do cidadão o montante correspondente aos custos de reprodução das informações fornecidas. Pessoas que comprovem não ter condições de arcar com tais custos estão isentas do pagamento.</p>
                            <p>• Referência na lei: Artigo 12.</p>

                        </div>

                    </div>


                    <div class="accordion" id="b1" data-aos="fade-up" data-aos-duration="1000"><span class="icon-question_answer text-primary mr-2"></span> Recursos contra negativa de acesso </div>

                    <div class="panel">

                        <div class="textodopainel">

                            <p>Devem ser feitos em no máximo 10 dias depois de recebida a negativa. Eles serão encaminhados à autoridade superior àquela que decidiu pela negativa de acesso. A autoridade tem até 5 dias para se manifestar sobre o recurso.</p>
                            <p>• Referência na lei: Artigo 15.</p>
                            <p>No caso de entidades do Executivo federal, se a autoridade superior em questão mantiver a negativa, o recurso será encaminhado à Controladoria-Geral da União (CGU), que tem o mesmo prazo para se manifestar (5 dias). Caso a CGU mantenha a negativa, o recurso será enviado à Comissão Mista de Reavaliação de Informações.</p>
                            <p>• Referência na lei: Artigo 16.</p>

                        </div>

                    </div>


                    <div class="accordion" id="b1" data-aos="fade-up" data-aos-duration="1000"><span class="icon-question_answer text-primary mr-2"></span> Punições a agentes públicos </div>

                    <div class="panel">

                        <div class="textodopainel">

                            <p>O agente público que se recusar a fornecer informações, retardar o acesso a elas ou fornecer dados incorretos deliberadamente comete infração administrativa, e poderá ser punido com, no mínimo, uma suspensão.</p>
                            <p>• Referência na lei: Artigo 32, § 1º, II.</p>
                            <p>Se for o caso, o agente público também poderá responder a processo por improbidade administrativa.</p>
                            <p>• Referência na lei: Artigo 32, § 2º.</p>
                            <p>O agente público que divulgar documentos considerados sigilosos sem autorização também é passível de punição.</p>
                            <p>• Referência na lei: Artigo 32, § 1º, IV.</p>

                        </div>

                    </div>


                    <div class="accordion" id="b1" data-aos="fade-up" data-aos-duration="1000"><span class="icon-question_answer text-primary mr-2"></span> Punição a entidades privadas </div>

                    <div class="panel">

                        <div class="textodopainel">

                            <p>Como a lei também prevê que entidades privadas com vínculos com o poder público devem divulgar informações, elas também podem ser punidas caso não cumpram as exigências. As sanções vão de advertência ou multa à rescisão do vínculo e à proibição de voltar a contratar com o poder público.</p>
                            <p>• Referência na lei: Artigo 33.</p>
                            <p>A entidade privada que divulgar documentos considerados sigilosos sem autorização também é passível de punição.</p>
                            <p>• Referência na lei: Artigo 32, § 1º, IV.</p>

                        </div>

                    </div>

                    <div class="accordion" id="b1" data-aos="fade-up" data-aos-duration="1000"><span class="icon-question_answer text-primary mr-2"></span> Sigilo de documentos </div>

                    <div class="panel">

                        <div class="textodopainel">

                            <p>Há três tipos de documentos confidenciais, cada qual com seu prazo para duração do sigilo.</p>

                            <table class="tDefault" style="width: 100%;" cellspacing="0" cellpadding="0">

                                <thead>

                                <tr>
                                    <td><strong>Classificação</strong></td>
                                    <td><strong>Duração do sigilo</strong></td>
                                    <td><strong>Renovável?</strong></td>
                                </tr>

                                </thead>

                                <tbody>

                                <tr>
                                    <td>Ultrassecreto</td>
                                    <td>25 anos</td>
                                    <td>Sim. Por apenas mais um período de 25 anos.</td>
                                </tr>

                                <tr>
                                    <td>Secreto</td>
                                    <td>15 anos</td>
                                    <td>Não.</td>
                                </tr>

                                <tr>
                                    <td class="noBorderB">Reservado</td>
                                    <td class="noBorderB">5 anos</td>
                                    <td class="noBorderB">Não.</td>
                                </tr>

                                </tbody>

                            </table>

                            <br>

                            <p>• Referência na lei: Artigo 24, § 1º I, II e III.</p>
                            <p>Após esses prazos, o acesso aos documentos é automaticamente liberado. Ou seja, o prazo máximo para que um documento seja mantido em sigilo é de 50 anos.</p>
                            <p>• Referência na lei: Artigo 24, § 4º.</p>
                            <p>As informações que possam colocar em risco a segurança do presidente e do vice-presidente da República e de seus familiares são consideradas reservadas. Em caso de reeleição, elas serão mantidas em sigilo até o término do mandato.</p>
                            <p>• Referência na lei: Artigo 24, § 2º.</p>
                            <p>Todos os órgãos e entidades públicas terão de divulgar anualmente uma lista com a quantidade de documentos classificados no período como reservados, secretos e ultrassecretos.</p>
                            <p>• Referência na lei: Artigo 30.</p>
                            <p>Em até dois anos a partir da entrada em vigor da lei, os órgãos e entidades públicas deverão reavaliar a classificação de informações secretas e ultrassecretas. Enquanto o prazo não acabar, valerá a legislação atual.</p>
                            <p>• Referência na lei: Artigo 39.</p>

                        </div>

                    </div>

                    <div class="accordion" id="b1" data-aos="fade-up" data-aos-duration="1000"><span class="icon-question_answer text-primary mr-2"></span> Comissão Mista de Reavaliação de Informações </div>

                    <div class="panel">

                        <div class="textodopainel">

                            <p>Sua composição exata será definida no decreto de regulamentação da lei.<br>• Referência na lei: Artigo 35, §5º.</p>
                            <p>As decisões da Comissão dizem respeito à administração pública federal. Ela poderá rever a classificação de informações como secretas e ultrassecretas e prorrogar, dentro do limite previsto na lei, a classificação de informações como ultrassecretas.<br>• Referência na lei: Artigo 35, § 1º, II e III.</p>
                            <p>Regula o acesso a informações previsto no inciso XXXIII do art. 5o, no inciso II do § 3o do art. 37 e no § 2o do art. 216 da Constituição Federal; altera a Lei no 8.112, de 11 de dezembro de 1990; revoga a Lei no 11.111, de 5 de maio de 2005, e dispositivos da Lei no 8.159, de 8 de janeiro de 1991; e dá outras providências.</p>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

    </div>

    <!-- FECHA FAQ -->
@endsection
@section('footer')

    <!-- SCRIPTS -->

    <script src="{{url('')}}/transpa/js/jquery-3.3.1.min.js"></script>
    <script src="{{url('')}}/transpa/js/popper.min.js"></script>
    <script src="{{url('')}}/transpa/js/bootstrap.min.js"></script>
    <script src="{{url('')}}/transpa/js/owl.carousel.min.js"></script>
    <script src="{{url('')}}/transpa/js/jquery.sticky.js"></script>
    <script src="{{url('')}}/transpa/js/jquery.waypoints.min.js"></script>
    <script src="{{url('')}}/transpa/js/jquery.animateNumber.min.js"></script>
    <script src="{{url('')}}/transpa/js/jquery.fancybox.min.js"></script>
    <script src="{{url('')}}/transpa/js/jquery.easing.1.3.js"></script>
    <script src="{{url('')}}/transpa/js/aos.js"></script>
    <script src="{{url('')}}/transpa/js/main.js"></script>
    <script src="{{url('')}}/transpa/js/accordion.js"></script>
    <script src="{{url('')}}/transpa/js/aos2.js"></script>
    <script src="{{url('')}}/transpa/js/aos3.js"></script>
    <!--<script src="js/main2.js"></script>-->
    <script src="{{url('')}}/transpa/js/barraacessibilidade.js"></script>
    <script src="{{url('')}}/transpa/js/nav.js"></script>
    <script src="{{url('')}}/transpa/js/botao.js"></script>

    <script type="text/javascript" src="{{url('')}}/transpa/plugins/numScroll/numscroller-1.0.js"></script>

    <script src="{{url('')}}/transpa/plugins/aos-master/aos.js"></script>

    <script type="text/javascript" src="{{url('')}}/transpa/plugins/niceScroll/niceScroll.min.js"></script>

    <!-- SCRIPTS -->
@endsection
