
@extends('templates.prefeitura3.transparencia.layout')

@section('header')

    <title>Servidores - Portal da Transparência</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link href="https://fonts.googleapis.com/css?family=Rubik:300,400,700|Oswald:400,700" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Open+Sans|Roboto&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Poppins&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

    <link rel="stylesheet" href="{{url('')}}/transpa/fonts/icomoon/style.css">

    <link rel="stylesheet" href="{{url('')}}/transpa/css/bootstrap.min.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/jquery.fancybox.min.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/owl.carousel.min.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/owl.theme.default.min.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/fonts/flaticon/font/flaticon.css">

    <link rel="stylesheet" href="{{url('')}}/transpa/css/aos.css">

    <!-- MAIN CSS -->
    <link rel="stylesheet" href="{{url('')}}/transpa/css/style.css">
{{--    <link rel="stylesheet" href="{{url('')}}/transpa/css/style2.css">--}}
{{--    <link rel="stylesheet" href="{{url('')}}/transpa/css/style5.css">--}}
{{--    <link rel="stylesheet" href="{{url('')}}/transpa/css/style7.css">--}}
    <link rel="stylesheet" href="{{url('')}}/transpa/css/footer.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/scss/barraacessibilidade.scss">
{{--    <link rel="stylesheet" href="{{url('')}}/transpa/css/barraacessibilidade.css">--}}
{{--    <link rel="stylesheet" href="{{url('')}}/transpa/css/accordion.css">--}}
    <link rel="stylesheet" href="{{url('')}}/transpa/css/formulariotabela.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/bootstrap-datepicker.css">
{{--    <link rel="stylesheet" href="{{url('')}}/transpa/font-awesome/css/font-awesome.min.css">--}}
    <link rel="stylesheet" href="{{url('')}}/transpa/font-awesome/css/all.css">
{{--    <link rel="stylesheet" href="{{url('')}}/transpa/css/bootstrap-datepicker2.css">--}}
    <link rel="stylesheet" href="{{url('')}}/transpa/css/font-awesome.min.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/css/modal.css">
    <link rel="stylesheet" href="{{url('')}}/transpa/plugins/aos-master/aos.css"/>
    <link rel="stylesheet" href="{{url('')}}/transpa/css/animations.css">

<style>

    .page-item.active .page-link {

        background-color: #337ab7!important;
        border-color: #337ab7;
    }
    .ui-datepicker-calendar {
        display: none;
    }
    @media(max-width: 574px) {


    }

</style>
 

@endsection


@section('menu')

    <!-- <li><a href="#home-section" class="nav-link">Página Inicial</a></li> -->
    <li><a href="{{routeTenant('site.transparencia.index')}}#about-section" class="nav-link">Sobre</a></li>
    <li><a href="{{routeTenant('site.transparencia.index')}}#nova-legislacao" class="nav-link">Legislação</a></li>
    <li><a href="{{routeTenant('site.transparencia.index')}}#faq" class="nav-link">Perguntas Frequentes</a></li>

@endsection



@section('content')


    <!-- BARRA -->

    <div class="container-fluid barra">

        <div class="container">

            <div class="row justify-content-center">

                <div class="col-md-6" style="padding: 10px;">

                    <p><i class="flaticon-groups"></i>&ensp;SERVIDORES PÚBLICOS</p>

                </div>

                <div class=" col-md-6">


                    <div class="botoes">

                        <div class="dropdown">

                            <button class="btn2"><i class="fa fa-print"></i> Imprimir</button>

                            <button class="btn2 dropdown-toggle" type="button" id="menu1" data-toggle="dropdown"><i class="fa fa-download"></i> Download</button>

                            <ul class="dropdown-menu botao-download" role="menu" aria-labelledby="menu1">

                                <li role="presentation"><a role="menuitem" href="#"><i class="fa fa-file-pdf"></i>&ensp;PDF</a></li>
                                <li role="presentation"><a role="menuitem" href="#"><i class="fa fa-file-excel"></i>&ensp;Excel</a></li>
                                <li role="presentation"><a role="menuitem" href="#"><i class="fa fa-file-csv"></i>&ensp;CSV</a></li>

                            </ul>

                        </div>

                    </div>




                </div>

            </div>

        </div>

    </div>

    <!-- FECHA BARRA -->



    <!-- TABELA E FORM -->

    <div class="container" id="containertabela" >


        <!-- FORMULÁRIO -->
        <form method="post" action="{{routeTenant('site.transparencia.servidores.busca')}}" class="form2">
        <div id="form1" style="margin-left: 0!important; width: 100%; z-index: 0;" >
            <input type="hidden" name="_token" value="{{csrf_token()}}">
            <div class="container">

                <div class="row">

                    <div class="col-md-12 search-wrap">

                        <form method="post" class="form2">

                            <div class="row">


                                <div class="col-md-2">

                                    <div class="form-group">

                                        <label for="#">Matrícula:</label>

                                        <div class="form-field">

                                            <input type="text" name="matricula" id="#" class="form-control" @if(isset($dataform['matricula'])) value="{{$dataform['matricula']}}" @endif placeholder="Nº da Matrícula">

                                        </div>

                                    </div>

                                </div>


                                <div class="col-md-7">

                                    <div class="form-group">

                                        <label for="#">Nome do Servidor ou da Servidora:</label>

                                        <div class="form-field">

                                            <input type="text" name="nomeservidor" id="#" @if(isset($dataform['nomeservidor'])) value="{{$dataform['nomeservidor']}}" @endif class="form-control" placeholder="Nome do(a) Servidor(a)">

                                        </div>

                                    </div>

                                </div>


                                <div class="col-md-3">

                                    <div class="form-group">

                                        <label for="#">Situação:</label>

                                        <div class="form-field">

                                            <label class="sr-only" for="#"></label>

                                            <select class="form-control" id="#" name="situacao">

                                                <option value="">Todas &nbsp;</option>
                                                <option @if(isset($dataform['situacao'])) @if($dataform['situacao'] =="I") selected @endif @endif  value="I"> Inativo </option>
                                                <option @if(isset($dataform['situacao'])) @if($dataform['situacao'] =="A") selected @endif @endif value="A"> Ativo </option>
                                                <option @if(isset($dataform['situacao'])) @if($dataform['situacao'] =="P") selected @endif @endif value="P"> Pensionista </option>
                                                <option @if(isset($dataform['situacao'])) @if($dataform['situacao'] =="O") selected @endif @endif value="O"> Outros </option>

                                            </select>

                                        </div>

                                    </div>

                                </div>


                                <div class="col-md-6">

                                    <div class="form-group">

                                        <label for="#">Unidade:</label>

                                        <div class="form-field">

                                            <label class="sr-only" for="#">Ano</label>

                                            <select class="form-control" id="#" name="unidade">

                                                <option value="">Todos as Unidades &nbsp;</option>
                                                <option value="#"> Unidade 1 </option>
                                                <option value="#"> Unidade 2 </option>
                                                <option value="#"> Unidade 3 </option>
                                                <option value="#"> Unidade 4 </option>
                                                <option value="#"> Unidade 5 </option>
                                                <option value="#"> Unidade 6 </option>
                                                <option value="#"> Unidade 7 </option>
                                                <option value="#"> Unidade 8 </option>

                                            </select>

                                        </div>

                                    </div>

                                </div>


                                <div class="col-md-6">

                                    <div class="form-group">

                                        <label for="#">Cargo/Função:</label>

                                        <div class="form-field">

                                            <label class="sr-only" for="#"></label>

                                            <select class="form-control" id="#" name="cargo">

                                                <option value="">Todos os Cargos &nbsp;</option>
                                                <option value="CEF"> cargo 1 </option>
                                                <option value="CRA"> cargo 2 </option>
                                                <option value="CRR"> cargo 3 </option>



                                            </select>

                                        </div>

                                    </div>

                                </div>


                                <div class="col-md-4">

                                    <div class="form-group">

                                        <label for="#">Regime:</label>

                                        <div class="form-field">

                                            <label class="sr-only" for="#"></label>

                                            <select class="form-control" id="#" name="regime">

                                                <option value="">Todos &nbsp;</option>
                                                <option @if(isset($dataform['regime'])) @if($dataform['regime'] =="CEF") selected @endif @endif  value="CEF"> Efetivo </option>
                                                <option @if(isset($dataform['regime'])) @if($dataform['regime'] =="CRA") selected @endif @endif  value="CRA"> Comissionado de recrutamento amplo </option>
                                                <option @if(isset($dataform['regime'])) @if($dataform['regime'] =="CRR") selected @endif @endif  value="CRR"> Comissionado de recrutamento restrito </option>
                                                <option @if(isset($dataform['regime'])) @if($dataform['regime'] =="FPU") selected @endif @endif  value="FPU"> Função pública </option>
                                                <option @if(isset($dataform['regime'])) @if($dataform['regime'] =="EPU") selected @endif @endif  value="EPU"> Emprego público </option>
                                                <option @if(isset($dataform['regime'])) @if($dataform['regime'] =="APO") selected @endif @endif  value="APO"> Agente político </option>
                                                <option @if(isset($dataform['regime'])) @if($dataform['regime'] =="STP") selected @endif @endif  value="STP"> Servidor temporário </option>
                                                <option @if(isset($dataform['regime'])) @if($dataform['regime'] =="OTC") selected @endif @endif  value="OTC"> Outros tipos de cargo </option>

                                            </select>

                                        </div>

                                    </div>

                                </div>


                                <div class="col-md-4">

                                    <div class="form-group">

                                        <label for="">Competência:</label>

                                        <div class="form-field">

                                            <label class="sr-only" for="#"></label>

                                            <input type="text" @if(isset($dataform['competencia'])) value="{{$dataform['competencia']}}" @endif  name="competencia" class="form-control datepicker1">

                                        </div>

                                    </div>

                                </div>


                                <div class="col-md-4">

                                    <input type="submit" name="submit" id="submit" value="Buscar" class="btn3">

                                </div>


                            </div>

                        </form>

                    </div>

                </div>

            </div>

        </div>
        </form>
        <!-- FECHA FORMULÁRIO -->



        <!-- ATUALIZAÇÃO -->

        <div class="container">

            <div class="row">

                <div class="atualizado col-md-12">
                    @php $dataatua =  \Illuminate\Support\Facades\DB::connection('another')->table($accont.'_transparencia_folha_flpgo')->orderBy('created_at', 'desc')->wherein('tipoRegistro',['10'])->where('account_id',$portal->id)->first(); @endphp
                    @if(isset($dataatua->created_at))
                    <p style="font-size: 14px;">Atualizado em: <span class="datadeatualizacao"><b>{{date('d/m/Y',  strtotime( $dataatua->created_at))}}</b></span><span class="horaatualizacao"> <b>{{date('H:i:s',  strtotime( $dataatua->created_at))}}</b></span> <!-- &nbsp;| &nbsp;Última arrecadação: <span class="atualizacaorecente"><b>01/02/03</b></span></p>-->
@endif
                </div>

            </div>

        </div>

        <!-- FECHA ATUALIZAÇÃO -->



        <!-- TABELA -->

        <div class="double-scroll" style="overflow-x:auto;">

            <table class="table table-hover table-fit" id="tabela1">

                <thead class="titulostabela">

                <tr>

                    <th>Matrícula</th>
                    <th>Nome</th>
                    <th>Unidade</th>
                    <th>Cargo</th>
                    <th>Situação</th>
                    <th>Regime</th>
                    <th width="10%">Salário</th>
                    <th>Competência</th>

                </tr>

                </thead>


                <tbody>

                @foreach($dadoscolection as $category)

                <tr class="linhas">

                    <td><a href="{{routeTenant('site.transparencia.servidores.detalhes',[$category->id])}}"  class="popup">{{$category->codMatriculaPessoa}}</a></td>
                    <td><a href="{{routeTenant('site.transparencia.servidores.detalhes',[$category->id])}}"  class="popup">{{$category->nome}}</a></td>
                    <td>{{$category->dscLotacao}}</td>
                    <td>{{$category->dscCargo}}</td>
                    <td>{{$category->indSituacaoServidorPensionista}}</td>
                    <td>{{$category->sglCargo}}</td>
                    <td>R$ {{number_format($category->vlrRemuneracaoBruta,2,",",".")}}</td>
                    <td>{{$category->competencia}}</td>

                </tr>

                @endforeach






                </tbody>

            </table>

        </div>

        <!-- FECHA TABELA -->


        <!-- TOTAL -->

        <div class="total">

            <p style="font-size: 16px;">Valor total: <span class="valortotal"><b>R$ @php echo $totalvalor; @endphp</b></span></p>

        </div>

        <!-- FECHA TOTAL -->

    </div>

    <!-- FECHA FORMULÁRIO E TABELA -->



    <!-- PAGINAÇÃO -->

    <div class="container">

        <div class="center">
            @if(isset($dataform))
                {!! $dadoscolection->appends($dataform)->links() !!}
            @else
                {!! $dadoscolection->links() !!}
            @endif

        </div>

    </div>

    <!-- FECHA PAGINAÇÃO -->



    <!-- MODAIS SERVIDORES -->


    <!-- "MATRÍCULA" -->



    <!-- FECHA "MATRÍCULA" -->


    <!-- "NOME" -->

    <div id="modal-servidores-2" class="modaldialog">

        <div class="modal-completo">


            <div class="panel-heading">

                <div class="row align-items-start">


                    <div class="col-8 col-sm-9 col-md-10 col-lg-8 col-xl-9 col-xxl-9 align-self-center">

                        <p class="panel-title"> <!--<i class="fa fa-lg fa-file-text"></i> &nbsp;--> SERVIDOR(A): <span>NOME DO SERVIDOR(A)</span></p>

                    </div>


                    <div class="col-lg-4 col-xl-3 col-xxl-3 botoes">

                        <button class="btn2"><i class="fa fa-print"></i> Imprimir</button>

                        <button class="btn2 dropdown-toggle" type="button" id="menu1" data-toggle="dropdown"><i class="fa fa-download"></i> Download</button>

                        <ul class="dropdown-menu botao-download" role="menu" aria-labelledby="menu1">

                            <li role="presentation"><a role="menuitem" href="#"><i class="fa fa-file-pdf"></i>&ensp;PDF</a></li>
                            <li role="presentation"><a role="menuitem" href="#"><i class="fa fa-file-excel"></i>&ensp;Excel</a></li>
                            <li role="presentation"><a role="menuitem" href="#"><i class="fa fa-file-csv"></i>&ensp;CSV</a></li>

                        </ul>

                    </div>


                    <div class="col-4 col-sm-3 col-md-2 botoesmobile">

                        <div class="dropdown">

                            <!-- <button class="btn2"><i class="fa fa-print"></i></button> -->
                            <button class="btn2 dropdown-toggle" type="button" id="menu1" data-toggle="dropdown"><i class="fa fa-download"></i></button>

                            <ul class="dropdown-menu botao-download" role="menu" aria-labelledby="menu1">

                                <li role="presentation"><a role="menuitem" href="#"><i class="fa fa-file-pdf"></i>&ensp;PDF</a></li>
                                <li role="presentation"><a role="menuitem" href="#"><i class="fa fa-file-excel"></i>&ensp;Excel</a></li>
                                <li role="presentation"><a role="menuitem" href="#"><i class="fa fa-file-csv"></i>&ensp;CSV</a></li>

                            </ul>

                        </div>

                    </div>

                    <a class="closemodal" href="#close">x</a>

                </div>

            </div>


            <div class="modal-corpo">

                <div class="tabela-scroll-modal">

                    <table class=" table-condensed table-bordered table-hover " id="tabelamodal">

                        <tbody>

                        <tr>
                            <td width="20%" class="tdcinza">Número da matrícula:</td>
                            <td> ##### </td>
                        </tr>

                        <tr>
                            <td width="20%" class="tdcinza">Nome:</td>
                            <td> ##### </td>
                        </tr>

                        <tr>
                            <td class="tdcinza">CPF: </td>
                            <td> ##### </td>
                        </tr>

                        <tr>
                            <td class="tdcinza">Competência: </td>
                            <td> ##### </td>
                        </tr>

                        <tr>
                            <td class="tdcinza">Data de admissão: </td>
                            <td> ##### </td>
                        </tr>

                        <tr>
                            <td class="tdcinza">Unidade: </td>
                            <td> ##### </td>
                        </tr>

                        <tr>
                            <td class="tdcinza">Cargo: </td>
                            <td> ##### </td>
                        </tr>

                        <tr>
                            <td class="tdcinza">Lotação: </td>
                            <td> ##### </td>
                        </tr>

                        <tr>
                            <td class="tdcinza">Situação: </td>
                            <td> ##### </td>
                        </tr>

                        <tr>
                            <td class="tdcinza">Vínculo: </td>
                            <td> ##### </td>
                        </tr>


                        <tr>
                            <td class="tdcinza">Tipo: </td>
                            <td> ##### </td>
                        </tr>

                        <tr>
                            <td class="tdcinza">Salário base: </td>
                            <td> ##### </td>
                        </tr>

                        <tr>
                            <td class="tdcinza">Valor líquido: </td>
                            <td> ##### </td>
                        </tr>

                        </tbody>

                    </table>

                </div>

            </div>

        </div>

    </div>

    <!-- FECHA "NOME" -->

    <!-- FECHA MODAIS SERVIDORES -->







    <!-- BOTÃO PARA O TOP -->

    <button onclick="topFunction()" id="myBtn" title="Go to top">&uarr;</button>

    <!-- FECHA BOTÃO PARA O TOP -->



    <!-- SCRIPTS -->



    <script type="text/javascript">
        $(document).ready(function() {
            $('.double-scroll').doubleScroll({resetOnWindowResize: true});
        });
    </script>

    <!-- FECHA SCRIPTS -->


    </div>




@endsection

    @section('footer')



        <script src="{{url('')}}/transpa/js/jquery-3.3.1.min.js"></script>
        <script src="{{url('')}}/transpa/js/popper.min.js"></script>
        <script src="{{url('')}}/transpa/js/bootstrap.min.js"></script>
        <script src="{{url('')}}/transpa/js/owl.carousel.min.js"></script>
        <script src="{{url('')}}/transpa/js/jquery.sticky.js"></script>
        <script src="{{url('')}}/transpa/js/jquery.waypoints.min.js"></script>
        <script src="{{url('')}}/transpa/js/jquery.animateNumber.min.js"></script>
        <script src="{{url('')}}/transpa/js/jquery.fancybox.min.js"></script>
        <script src="{{url('')}}/transpa/js/jquery.easing.1.3.js"></script>
        <script src="{{url('')}}/transpa/js/aos.js"></script>
{{--        <script src="{{url('')}}/transpa/js/bootstrap-datepicker.js"></script>--}}
{{--        <script src="{{url('')}}/transpa/js/bootstrap-datepicker.pt-BR.js"></script>--}}

        <script src="{{url('')}}/transpa/js/main.js"></script>

        <script src="{{url('')}}/transpa/js/accordion.js"></script>
        <script src="{{url('')}}/transpa/js/jquery.flexslider-min.js"></script>

        <script src="{{url('')}}/transpa/js/aos2.js"></script>
        <script src="{{url('')}}/transpa/js/aos3.js"></script>
        <!--<script src="js/main2.js"></script>-->
        <script src="{{url('')}}/transpa/js/barraacessibilidade.js"></script>
        <script src="{{url('')}}/transpa/js/nav.js"></script>
        <script src="{{url('')}}/transpa/js/botao.js"></script>


        <script src="{{url('')}}/transpa/js/jquery.waypoints.min2.js"></script>
        <script src="{{url('')}}/transpa/js/jquery.flexslider-min2.js"></script>
        <script src="{{url('')}}/transpa/js/owl.carousel.min2.js"></script>
        <script src="{{url('')}}/transpa/js/main3.js"></script>



        <script type="text/javascript" src="{{url('')}}/transpa/plugins/numScroll/numscroller-1.0.js"></script>


        <script src="{{url('')}}/transpa/plugins/aos-master/aos.js"></script>



        <script src="{{url('')}}/templates/prefeitura1/licitacao/js/jquery.fancybox.js"></script>
        <link href="{{url('')}}/templates/prefeitura1/licitacao/css/jquery.fancybox.css" rel="stylesheet">
        <script type="text/javascript">
            $(function(){
                $('.fancybox').fancybox();
                $(".popup").fancybox({'width':'80%','height':'80%','autoScale':true,
                    'fitToView' : false,
                    'autoSize' : false,
                    'transitionIn':'none',
                    'transitionOut':'none',
                    'type':'iframe'});


            });


        </script>


        <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">


        <script>

            jQuery(function($){
                $.datepicker.regional['pt-BR'] = {
                    closeText: 'Fechar',
                    prevText: '&#x3c;Anterior',
                    nextText: 'Pr&oacute;ximo&#x3e;',
                    currentText: 'Hoje',
                    monthNames: ['Janeiro','Fevereiro','Mar&ccedil;o','Abril','Maio','Junho',
                        'Julho','Agosto','Setembro','Outubro','Novembro','Dezembro'],
                    monthNamesShort: ['Jan','Fev','Mar','Abr','Mai','Jun',
                        'Jul','Ago','Set','Out','Nov','Dez'],
                    dayNames: ['Domingo','Segunda-feira','Ter&ccedil;a-feira','Quarta-feira','Quinta-feira','Sexta-feira','Sabado'],
                    dayNamesShort: ['Dom','Seg','Ter','Qua','Qui','Sex','Sab'],
                    dayNamesMin: ['Dom','Seg','Ter','Qua','Qui','Sex','Sab'],
                    weekHeader: 'Sm',
                    dateFormat: 'dd/mm/yy',
                    firstDay: 0,
                    isRTL: false,
                    showMonthAfterYear: false,
                    yearSuffix: ''};
                $.datepicker.setDefaults($.datepicker.regional['pt-BR']);
            });

            $(document).ready(function () {
                $('.datepicker1').datepicker({
                    changeMonth: true,
                    changeYear: true,
                    showButtonPanel: true,
                    dateFormat: 'mm/yy',
                    onClose: function(dateText, inst) {
                        $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
                    }
                });





            });













        </script>

    @endsection
